/*ALIAS>l_data*/

/*SQLStart>1006*/
CREATE DOMAIN REAL4 AS DECIMAL(15,4);
/*SQLSTOP*/

/*SQLStart>1007*/
CREATE TABLE ADSSIGNS (
	ADS_ID INTEGER NOT NULL,
	ADS_TERMPERM_ID INTEGER NOT NULL,
	ADS_ADDRESS VARCHAR(800),
	ADS_REGION VARCHAR(100),
	ADS_PRICE REAL3,
	ADS_SIDES INTEGER,
	ADS_WIDTH REAL4,
	ADS_HEIGHT REAL4,
	ADS_AREA_SIDE REAL4,
	ADS_AREA REAL4,
	ADS_COUNT INTEGER,
	ADS_PRICE_TOTAL REAL3);
/*SQLStop*/

/*SQLStart>1008*/
ALTER TABLE ADSSIGNS ADD CONSTRAINT PK_ADSSIGNS PRIMARY KEY (ADS_ID);
/*SQLStop*/

/*SQLStart>1009*/
CREATE GENERATOR ADSSIGNS_ID_GEN;
/*SQLStop*/

/*SQLStart>1010*/
CREATE TABLE ADSSIGNS_HIST (
	ID INTEGER NOT NULL,
	HISTORY_DATE DATE NOT NULL,
	HISTORY_TYPE INTEGER NOT NULL,
	HISTORY_GROUP INTEGER DEFAULT 0 NOT NULL,
	USER_ID INTEGER NOT NULL,
	ADS_ID INTEGER NOT NULL,
	ADS_TERMPERM_ID INTEGER NOT NULL,
	ADS_ADDRESS VARCHAR(800),
	ADS_REGION VARCHAR(100),
	ADS_PRICE REAL3,
	ADS_SIDES INTEGER,
	ADS_WIDTH REAL4,
	ADS_HEIGHT REAL4,
	ADS_AREA_SIDE REAL4,
	ADS_AREA REAL4,
	ADS_COUNT INTEGER,
	ADS_PRICE_TOTAL REAL3);
/*SQLStop*/
	
/*SQLStart>1011*/
ALTER TABLE ADSSIGNS_HIST ADD CONSTRAINT PK_ADSSIGNS_HIST PRIMARY KEY (ID);
/*SQLStop*/

/*SQLStart>1012*/
CREATE GENERATOR GEN_HIST_ADSSIGNS_ID;
/*SQLStop*/

/*SQLStart>1013*/
CREATE INDEX ADSSIGNS_HIST_HG ON ADSSIGNS_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>1014*/
CREATE OR ALTER TRIGGER adssigns_bi for adssigns
active BEFORE INSERT OR UPDATE position 0
as
begin
if (new.ads_id is null) then
	new.ads_id = gen_id(ADSSIGNS_ID_GEN,1);
end
/*SQLStop*/

/*SQLStart>1015*/
CREATE OR ALTER TRIGGER ADSSIGNS_HIST_BI FOR ADSSIGNS_HIST
ACTIVE BEFORE INSERT OR UPDATE POSITION 0
as 
begin 
if (new.ID is null) then 
	new.ID = gen_id(GEN_HIST_ADSSIGNS_ID,1); 
if (new.HISTORY_DATE is null) then 
	new.HISTORY_DATE = current_timestamp; 
end
/*SQLStop*/

/*SQLStart>1016*/
GRANT ALL ON ADSSIGNS TO PUBLIC;
/*SQLStop*/

/*SQLStart>1017*/
GRANT ALL ON ADSSIGNS_HIST TO PUBLIC;
/*SQLStop*/

/*SQLStart>1018*/
ALTER TABLE TERMPERM ADD TP_ADSTEXT VARCHAR(1000);
/*SQLStop*/

/*SQLStart>1019*/
ALTER TABLE TERMPERM_HIST ADD TP_ADSTEXT VARCHAR(1000);
/*SQLStop*/

/*SQLStart>1020*/
delete from system_strings where SYS_ID = 0;
/*SQLStop*/

/*SQLStart>1021*/
insert into system_strings (SYS_ID,SYS_STR) values (0,'1.5.50.1');
/*SQLStop*/

