/*ALIAS>prop_db*/

/*SQLStart>2804*/
CREATE GENERATOR PaymentChannels_ID_GEN;
/*SQLStop*/

/*SQLStart>2805*/
SET GENERATOR PaymentChannels_ID_GEN to 0;
/*SQLStop*/

/*SQLStart>2806*/
CREATE TABLE PaymentChannels(
	PC_ID INTEGER NOT NULL,
	PC_DisplayName VARCHAR(250) NOT NULL,
	PC_SystemName VARCHAR(250) NOT NULL
);
/*SQLStop*/

/*SQLStart>2807*/
ALTER TABLE PaymentChannels
ADD CONSTRAINT PC_PRIMARYKEY PRIMARY KEY (PC_ID);
/*SQLStop*/

/*SQLStart>2808*/
CREATE UNIQUE INDEX PC_SN_Unique ON PaymentChannels (PC_SystemName);
/*SQLStop*/

/*SQLStart>2809*/
CREATE  TRIGGER Set_PaymentChannels_ID_GEN for PaymentChannels
BEFORE INSERT 
AS
BEGIN
  new.PC_ID = gen_id(PaymentChannels_ID_GEN, 1);
END;
/*SQLStop*/

/*SQLStart>2810*/
GRANT all ON PaymentChannels to public;
/*SQLStop*/

/*SQLStart>2811*/
ALTER TABLE Invoices
ADD IN_PaymentChannelID INTEGER;
/*SQLStop*/

/*SQLStart>2812*/
ALTER TABLE Invoices
ADD CONSTRAINT FK_PaymentChannels_Invoices
FOREIGN KEY (IN_PaymentChannelID) REFERENCES PaymentChannels(PC_ID);
/*SQLStop*/

/*SQLStart>2813*/
CREATE OR ALTER procedure INVOICEADDHEADER (
    IN_PERID integer,
    IN_PAYID integer,
    IN_PAYTYPE char(1),
    IN_PAYSUM numeric(15,2),
    IN_PAYCLEARSUM numeric(15,2),
    IN_PAYDDS numeric(15,2),
    IN_PAYLIHVI numeric(15,2),
    IN_PAYWAY char(1),
    IN_COMMENT blob sub_type 1 segment size 4096,
    IN_PAYTEXT varchar(250),
    IN_OPERATORID integer,
    IN_OBMOL varchar(50),
    IN_PERPAYFROM varchar(50),
    IN_PAYNODDSSUM numeric(15,2),
    IN_PAYDDSSUM numeric(15,2),
    IN_FACTOR numeric(15,2),
    IN_PAYDATE date,
    IN_REALPAYDATE date,
    IN_NODDSDESCR varchar(255),
    IN_DDSEVENTDATE date,
    IN_PAYMENTCHANNELID integer)
returns (
    IN_ID integer)
as
declare variable IN_OPERATORNAME varchar(140);
declare variable IN_PERNAME varchar(140);
declare variable IN_PERADDR varchar(250);
declare variable IN_PERNM varchar(30);
declare variable IN_PEREGN varchar(15);
declare variable IN_PERDANN varchar(10);
declare variable IN_PERMOLNAME varchar(140);
declare variable IN_PERINDDS varchar(15);
declare variable IN_PER_ADDR_CORESP varchar(250);
declare variable IN_PER_TDNAP varchar(20);
declare variable IN_PER_TDNAP_ADDR varchar(50);
begin
  /* wzima se imeto na kasiera */
  select USER_STR from users
  where USER_ID = :IN_OperatorID
  into :IN_OperatorName;

  /* wzimat se dannite na personata */
  select PerName, PerEgn, PerDanN, PerAddr, PerNM, PerMolName, PerINDDS, PerAddr_Coresp, PerTDNap, PerTDNap_Addr
  from PersonGetInfo(:IN_PerID)
  into :IN_PerName, :IN_PerEgn, :IN_PerDanN, :IN_PerAddr, :IN_PerNM, :IN_PERMOLNAME, :IN_PERINDDS,
  :IN_PER_ADDR_CORESP, :IN_PER_TDNAP, :IN_PER_TDNAP_ADDR;

  if (IN_PAYDATE < "01.01.1990" ) then
    IN_PayDate = "NOW";

  if (IN_DDSEVENTDATE < "01.01.1990" ) then
    IN_DDSEVENTDATE = IN_PayDate;
  
  IN_ID = GEN_ID(IN_ID_GEN, 1);
  insert into Invoices (IN_ID, IN_PERID, IN_PERNAME, IN_PERADDR, IN_PERNM, IN_PEREGN,
                        IN_PERDANN, IN_PERMOLNAME, IN_PAYTYPE, IN_PAYTEXT, IN_PAYID,
                        IN_PAYSUM, IN_PAYDDS, IN_OPERATORID, IN_OPERATORNAME, IN_PAYLIHVI,
                        IN_PAYWAY, IN_ANUL, IN_COMMENT, IN_PAYCLEARSUM,
                        IN_OBMOL, IN_REAL, IN_PerPayFrom,
                        IN_PayDDSSum, IN_PayNoDDSSum, IN_FACTOR, IN_PAYDATE, IN_REALPAYDATE, 
                        IN_PERINDDS, IN_FLAG2007, IN_NODDSDESCR, IN_DDSEVENTDATE,
                        IN_PER_ADDR_CORESP, IN_PER_TDNAP, IN_PER_TDNAP_ADDR, IN_PAYMENTCHANNELID)
  values               (:IN_ID, :IN_PERID, :IN_PERNAME, :IN_PERADDR, :IN_PERNM, :IN_PEREGN,
                        :IN_PERDANN, :IN_PERMOLNAME, :IN_PAYTYPE, :IN_PAYTEXT, :IN_PAYID,
                        :IN_PAYSUM, :IN_PAYDDS, :IN_OPERATORID, :IN_OPERATORNAME, :IN_PAYLIHVI,
                        :IN_PAYWAY, "A", :IN_COMMENT, :IN_PAYCLEARSUM,
                        :IN_OBMOL, "F", :IN_PerPayFrom,
                        :IN_PayDDSSum, :IN_PayNoDDSSum, :IN_FACTOR, :IN_PAYDATE, :IN_REALPAYDATE,
                        :IN_PERINDDS, "T", :IN_NODDSDESCR, :IN_DDSEVENTDATE,
                        :IN_PER_ADDR_CORESP, :IN_PER_TDNAP, :IN_PER_TDNAP_ADDR, :IN_PAYMENTCHANNELID);
  
  suspend;
end;
/*SQLStop*/

/*SQLStart>2814*/
insert into users (user_id, user_unitid, user_str, user_name, user_active_kasa, user_active_rents, user_active_properties, user_active_incomes)
values (0, 0, ' ', ' ', 1, 1, 1, 1);
/*SQLStop*/

/*SQLStart>2815*/
UPDATE Invoices
SET IN_OPERATORID = 0, IN_OPERATORNAME = ' '
WHERE IN_OPERATORID = 9999;
/*SQLStop*/

/*SQLStart>2816*/
UPDATE Invoices inv
SET inv.IN_OPERATORID = 0, inv.IN_OPERATORNAME = COALESCE(inv.IN_OPERATORNAME, ' ')
WHERE not exists(SELECT 1 FROM users u WHERE u.USER_ID = inv.IN_OPERATORID);
/*SQLStop*/

/*SQLStart>2817*/
UPDATE Payment
SET P_USERID = 0, P_OPERATORNAME = ' '
WHERE P_USERID = 9999;
/*SQLStop*/

/*SQLStart>2818*/
UPDATE Payment pm
SET pm.P_USERID = 0, pm.P_OPERATORNAME = COALESCE(pm.P_OPERATORNAME, ' ')
WHERE not exists(SELECT 1 FROM users u WHERE u.USER_ID = pm.P_USERID);
/*SQLStop*/

/*SQLStart>2819*/
UPDATE Daypayments
SET DP_OPID = 0
WHERE DP_OPID = 9999;
/*SQLStop*/

/*SQLStart>2820*/
UPDATE Daypayments dps
SET dps.DP_OPID = 0
WHERE not exists(SELECT 1 FROM users u WHERE u.USER_ID = dps.DP_OPID);
/*SQLStop*/

/*SQLStart>2821*/
UPDATE PayTaking
SET PT_OperatorID = 0
WHERE PT_OperatorID = 9999;
/*SQLStop*/

/*SQLStart>2822*/
UPDATE PayTaking pt
SET pt.PT_OperatorID = 0
WHERE not exists(SELECT 1 FROM users u WHERE u.USER_ID = pt.PT_OperatorID);
/*SQLStop*/

/*SQLStart>2823*/
DELETE FROM Users
WHERE USER_ID = 9999;
/*SQLStop*/

/*SQLStart>2824*/
ALTER TABLE Invoices
ADD CONSTRAINT FK_Users_Invoices
FOREIGN KEY (IN_OPERATORID) REFERENCES Users(USER_ID);
/*SQLStop*/

/*SQLStart>2825*/
ALTER TABLE Payment
ADD CONSTRAINT FK_Users_Payments
FOREIGN KEY (P_USERID) REFERENCES Users(USER_ID);
/*SQLStop*/

/*SQLStart>2826*/
ALTER TABLE Daypayments
ADD CONSTRAINT FK_Users_Daypayments
FOREIGN KEY (DP_OPID) REFERENCES Users(USER_ID);
/*SQLStop*/

/*SQLStart>2827*/
ALTER TABLE PayTaking
ADD CONSTRAINT FK_Users_PayTakings
FOREIGN KEY (PT_OperatorID) REFERENCES Users(USER_ID);
/*SQLStop*/

/*SQLStart>2828*/
UPDATE Transactions
SET TR_STATE = 2
WHERE TR_STATE = 3;
/*SQLStop*/

/*SQLStart>2829*/
UPDATE Indetail ind
SET ind.ID_MASTERINVOICE = 0
WHERE (ind.ID_MASTERINVOICE > (SELECT MAX(inv.IN_ID) FROM Invoices inv));
/*SQLStop*/

/*SQLStart>2830*/
ALTER TABLE Payment
ADD CONSTRAINT FK_Transactions_Payments
FOREIGN KEY (P_TRANSACTION_ID) REFERENCES Transactions(TR_ID);
/*SQLStop*/

/*SQLStart>2831*/
UPDATE Renttypes rt
SET rt.RT_UNITID = 0
WHERE not exists(SELECT 1 FROM Obunits obs WHERE obs.unit_perid = rt.RT_UNITID);
/*SQLStop*/

/*SQLStart>2832*/
UPDATE Renttypes rt
SET rt.RT_UNITID_L = 0
WHERE not exists(SELECT 1 FROM Obunits obs WHERE obs.unit_perid = rt.RT_UNITID_L);
/*SQLStop*/

/*SQLStart>2833*/
UPDATE Renttypes rt
SET rt.RT_UNITID_D = 0
WHERE not exists(SELECT 1 FROM Obunits obs WHERE obs.unit_perid = rt.RT_UNITID_D);
/*SQLStop*/

/*SQLStart>2834*/
ALTER TABLE Renttypes
ADD CONSTRAINT FK_Obunits_Renttypes
FOREIGN KEY (RT_UNITID) REFERENCES Obunits(UNIT_PERID);
/*SQLStop*/

/*SQLStart>2835*/
ALTER TABLE Renttypes
ADD CONSTRAINT FK_Obunits_L_Renttypes
FOREIGN KEY (RT_UNITID_L) REFERENCES Obunits(UNIT_PERID);
/*SQLStop*/

/*SQLStart>2836*/
ALTER TABLE Renttypes
ADD CONSTRAINT FK_Obunits_D_Renttypes
FOREIGN KEY (RT_UNITID_D) REFERENCES Obunits(UNIT_PERID);
/*SQLStop*/

/*SQLStart>2837*/
UPDATE Indetail ind
SET ind.ID_UNITID = 0
WHERE not exists(SELECT 1 FROM Obunits obs WHERE obs.unit_perid = ind.ID_UNITID);
/*SQLStop*/

/*SQLStart>2838*/
UPDATE Indetail ind
SET ind.ID_UNITID_L = 0
WHERE not exists(SELECT 1 FROM Obunits obs WHERE obs.unit_perid = ind.ID_UNITID_L);
/*SQLStop*/

/*SQLStart>2839*/
UPDATE Indetail ind
SET ind.ID_UNITID_D = 0
WHERE not exists(SELECT 1 FROM Obunits obs WHERE obs.unit_perid = ind.ID_UNITID_D);
/*SQLStop*/

/*SQLStart>2840*/
ALTER TABLE Indetail
ADD CONSTRAINT FK_Obunits_Indetail
FOREIGN KEY (ID_UNITID) REFERENCES Obunits(UNIT_PERID);
/*SQLStop*/

/*SQLStart>2841*/
ALTER TABLE Indetail
ADD CONSTRAINT FK_Obunits_L_Indetail
FOREIGN KEY (ID_UNITID_L) REFERENCES Obunits(UNIT_PERID);
/*SQLStop*/

/*SQLStart>2842*/
ALTER TABLE Indetail
ADD CONSTRAINT FK_Obunits_D_Indetail
FOREIGN KEY (ID_UNITID_D) REFERENCES Obunits(UNIT_PERID);
/*SQLStop*/

/*SQLStart>2843*/
UPDATE Invoices inv
SET inv.IN_OBUNIT = 0
WHERE not exists(SELECT 1 FROM Obunits obs WHERE obs.unit_perid = inv.IN_OBUNIT);
/*SQLStop*/

/*SQLStart>2844*/
UPDATE Invoices inv
SET inv.IN_OPERATORUNITID = 0
WHERE not exists(SELECT 1 FROM Obunits obs WHERE obs.unit_perid = inv.IN_OPERATORUNITID);
/*SQLStop*/

/*SQLStart>2845*/
ALTER TABLE Invoices
ADD CONSTRAINT FK_Obunits_Invoices
FOREIGN KEY (IN_OBUNIT) REFERENCES Obunits(UNIT_PERID);
/*SQLStop*/

/*SQLStart>2846*/
ALTER TABLE Invoices
ADD CONSTRAINT FK_Obunits_O_Invoices
FOREIGN KEY (IN_OPERATORUNITID) REFERENCES Obunits(UNIT_PERID);
/*SQLStop*/

/*SQLStart>2847*/
UPDATE Daypayments dps
SET dps.DP_UNITID = 0
WHERE not exists(SELECT 1 FROM Obunits obs WHERE obs.unit_perid = dps.DP_UNITID);
/*SQLStop*/

/*SQLStart>2848*/
UPDATE Daypayments dps
SET dps.DP_OPERATORUNITID = 0
WHERE not exists(SELECT 1 FROM Obunits obs WHERE obs.unit_perid = dps.DP_OPERATORUNITID);
/*SQLStop*/

/*SQLStart>2849*/
ALTER TABLE Daypayments 
ADD CONSTRAINT DP_UID_NOTNULL 
check (DP_UNITID is not null);
/*SQLStop*/

/*SQLStart>2850*/
ALTER TABLE Daypayments 
ADD CONSTRAINT DP_OUID_NOTNULL 
check (DP_OPERATORUNITID is not null);
/*SQLStop*/

/*SQLStart>2851*/
ALTER TABLE Daypayments
ADD CONSTRAINT FK_Obunits_Daypayments
FOREIGN KEY (DP_UNITID) REFERENCES Obunits(UNIT_PERID);
/*SQLStop*/

/*SQLStart>2852*/
ALTER TABLE Daypayments
ADD CONSTRAINT FK_Obunits_O_Daypayments
FOREIGN KEY (DP_OPERATORUNITID) REFERENCES Obunits(UNIT_PERID);
/*SQLStop*/

/*SQLStart>2853*/
UPDATE Users u
SET u.USER_UNITID = 0
WHERE not exists(SELECT 1 FROM Obunits obs WHERE obs.unit_perid = u.USER_UNITID);
/*SQLStop*/

/*SQLStart>2854*/
ALTER TABLE Users
ADD CONSTRAINT FK_Obunits_Users
FOREIGN KEY (USER_UNITID) REFERENCES Obunits(UNIT_PERID);
/*SQLStop*/

/*SQLStart>2855*/
UPDATE system_strings SET sys_str = '6.7.239.1' WHERE sys_id = 1401;
/*SQLStop*/