/*ALIAS>prop_db*/

/*SQLStart>2115*/
-- NE SMENQITE STYPKITE, PUSKANI SA WE4E!!!

CREATE OR ALTER procedure ADD_WPID_TO_BROKEN_PAYMENTS
as
    declare variable DOCUMENT_ID integer;
    declare variable PAYMENT_NUM integer;
    declare variable WAIT_PAYMENT_ID integer;

begin
    for
        SELECT  payment.p_id,
                payment.p_num
        FROM    payment
        WHERE   (payment.p_inctype <> 0)
                AND ((payment.p_wpid = 0)
                    OR  (payment.p_wpid IS NULL))
        INTO    :DOCUMENT_ID,
                :PAYMENT_NUM
    do
    begin
        SELECT  waitpayments.wp_id
        FROM    payment
                INNER JOIN  invoices invoice_second
                    ON  (invoice_second.in_id = payment.p_flag)
                INNER JOIN  documents
                    ON  (payment.p_id = documents.doc_id)
                        AND (documents.doc_id = invoice_second.in_payid)
                INNER JOIN  invoices invoice_master
                    ON  (invoice_master.in_id = invoice_second.in_masterinvoice)
                INNER JOIN  waitpayments
                    ON  (invoice_master.in_id = waitpayments.wp_inid)
        WHERE   (payment.p_id = :DOCUMENT_ID)
                AND (payment.p_num = :PAYMENT_NUM)
        INTO    :WAIT_PAYMENT_ID
        ;
        UPDATE  payment
        SET     payment.p_wpid = :WAIT_PAYMENT_ID
        WHERE   (payment.p_id = :DOCUMENT_ID)
                AND (payment.p_num = :PAYMENT_NUM)
        ;
    end
end;
/*SQLStop>*/

/*ManyStart>2120*/
execute procedure ADD_WPID_TO_BROKEN_PAYMENTS;
/*ManyStop*/

/*ManyStart>2125*/
drop procedure ADD_WPID_TO_BROKEN_PAYMENTS;
/*ManyStop*/

/*ManyStart>2130*/
update rentsinfo set RI_DAYPRICE = 0.0 where (RI_DAYPRICE < 0.005) and (RI_DAYPRICE > -0.005);
update rentsinfo set RI_CARRIED = 0.0 where (RI_CARRIED < 0.005) and (RI_CARRIED > -0.005);
update rentsinfo set RI_CARRIEDINTEREST = 0.0 where (RI_CARRIEDINTEREST < 0.005) and (RI_CARRIEDINTEREST > -0.005);
update rentsinfo set RI_PAIDINTEREST = 0.0 where (RI_PAIDINTEREST < 0.005) and (RI_PAIDINTEREST > -0.005);
/*ManyStop*/

/*SQLStart>2135*/
create or alter procedure FixOperDate
as
declare variable PID integer;
declare variable PNUM integer;
declare variable PAYDATE timestamp;
begin
  for
    select payment.p_id,
             payment.p_num,
             invoices.in_paydate
    from payment
    inner join invoices on payment.p_flag = invoices.in_id
    where
        (astriptime(invoices.in_absolute_date) <> astriptime(invoices.in_paydate) ) and
        (astriptime(invoices.in_paydate) <> astriptime(payment.p_data))
    into :Pid,
         :Pnum,
         :Paydate
    do
        update payment
        set p_data = :Paydate
        where
            (p_id = :Pid) and
            (p_num = :Pnum);
end;
/*SQLStop>*/

/*SQLStart>2140*/
execute procedure FixOperDate;
/*SQLStop>*/

/*SQLStart>2145*/
drop procedure FixOperDate;
/*SQLStop>*/

/*SQLStart>2150*/
ALTER TABLE DOCUMENTS
    ADD DOC_TOTAL_PRICE VARCHAR(150);
/*SQLStop*/

/*SQLStart>2155*/
update system_strings set sys_str = '6.7.179.1' where sys_id = 1401;  /*BackOffice*/
/*SQLStop*/