/*ALIAS>prop_db*/

/*SQLStart>2080*/
CREATE OR ALTER trigger taxigroups_bi for taxigroups
active before insert position 0
AS
BEGIN
  if ((NEW.TG_ID is NULL) OR (NEW.TG_ID < 1)) then
  begin
    NEW.TG_ID = GEN_ID(TG_ID_GEN, 1);
  end
END
/*SQLStop>*/

/*SQLStart>2081*/
CREATE INDEX ORIGINALS_IDX ON ORIGINALS (ORIGINALS_DOCID,ORIGINALS_RESID);
/*SQLStop*/

/*SQLStart>2082*/
CREATE OR ALTER trigger SET_PER_ID for PERSONS
active before insert position 0
AS
BEGIN
  if ((new.PER_ID is null) or (new.PER_ID = 0))  then
  begin
    NEW.Per_ID=GEN_ID(Per_ID_GEN,1);
  end
  New.Per_Name = ATrimEx(New.Per_Name);
  New.Per_CLEARNAME = ACLearStr(New.Per_Name);
  New.Per_CLEAREGN = ACLearStr(New.Per_EGN);
END
/*SQLStop*/

/*ManyStart>2083*/
update system_strings set sys_str = '6.7.177.1' where sys_id = 1401;  /*BackOffice*/
/*ManyStop*/