/*ALIAS>prop_db*/

/*SQLStart>1475*/
alter table DAYPAYMENTS
  add DP_ID integer not null,
  add DP_RecordKind smallint not null,
  add DP_PayWay char(1),
  add DP_ANUL char(1),
  add DP_PayType char(1),
  add DP_operatorunitid integer
;
/*SQLStop>1475*/

/*SQLStart>1476*/
create generator daypaymentsid;
/*SQLStop>1476*/

/*SQLStart>1477*/
create procedure setdpid
as
declare variable dp_inid integer;
declare variable dp_opid integer;
declare variable dp_date date;
declare variable dp_accno varchar(20);
declare variable dp_partno varchar(20);
declare variable dp_flag char(1);
declare variable dp_id integer;

declare variable in_payway char(1);
declare variable in_anul char(1);
declare variable in_paytype char(1);
declare variable in_operatorunitid integer;
begin
  for select dp_inid, dp_opid, dp_date, dp_accno, dp_partno, dp_flag, in_operatorunitid, in_payway, in_paytype, in_anul
      from daypayments inner join invoices on (in_id = dp_inid)
      into  :dp_inid, :dp_opid, :dp_date, :dp_accno, :dp_partno, :dp_flag, :in_operatorunitid, :in_payway, :in_paytype, :in_anul
  do begin
    dp_id = gen_id(daypaymentsid, 1);

    update daypayments set 
      dp_id = :dp_id,
      dp_recordkind = 0,
      dp_operatorunitid = :in_operatorunitid,
      dp_payway = :in_payway,
      dp_paytype = :in_paytype,
      dp_anul = :in_anul
      where
        dp_inid = :dp_inid and
        dp_opid = :dp_opid and
        dp_date = :dp_date and
        dp_accno = :dp_accno and 
        dp_partno = :dp_partno and
        dp_flag = :dp_flag;
  end
end;
/*SQLStop>1477*/

/*SQLStart>1478*/
execute procedure setdpid;
/*SQLStop>1478*/

/*SQLStart>1479*/
drop procedure setdpid;
/*SQLStop>1479*/

/*DLLStart>1480*/     
DLLName=upd109.dll    
DLLProc=pk1fix
/*DLLStop*/ 

/*SQLStart>1481*/
ALTER TABLE DAYPAYMENTS ADD PRIMARY KEY (DP_ID);
/*SQLStop>1481*/

/*SQLStart>1482*/
alter TRIGGER INDETAIL_BI 
AS
BEGIN
  exit;
END
/*SQLStop>1482*/

/*SQLStart>1483*/
ALTER PROCEDURE DAYPAYMENTSADD(
    DP_OPID INTEGER,
    DP_DATE DATE,
    DP_ACCNO VARCHAR(8),
    DP_PARTNO VARCHAR(18),
    DP_CREDIT NUMERIC(15,2),
    DP_FLAG CHAR(1),
    DP_INID INTEGER,
    DP_BIN VARCHAR(10),
    DP_UNITID INTEGER,
    DP_PayWay char(1),
    DP_Anul char(1),
    DP_PayType char(1),
    DP_OperatorUnitId integer
)
AS
declare variable cnt integer;
declare variable dp_debit numeric(15,2);
declare variable dp_saldo numeric(15,2);
declare variable dp_cleardate date;
declare variable dp_incid smallint;
declare variable dp_id integer;
begin
  select count(*) from DayPayments
  where DP_OPID = :DP_OPID and DP_Date = :DP_Date and
        DP_AccNo = :DP_AccNo and DP_PartNo = :DP_PartNo and
        DP_INID = :DP_INID  and DP_FLAG = :DP_FLAG
        and DP_RecordKind = 0
  into :cnt;

  dp_saldo = dp_credit;
  dp_cleardate = AStripTime(DP_DATE);

  if (dp_credit < 0) then
  begin
    dp_debit = dp_credit;
    dp_credit = 0;
  end
  else
    dp_debit = 0; 

  if ((cnt is null) or (cnt = 0)) then
  begin
    dp_id = gen_id(daypaymentsid,1);
    select P_IncID from Partitions where P_AccNo = :DP_AccNo and P_No = :DP_PartNo into :dp_incid;
    if (dp_incid is null) then dp_incid = 0;
    insert into DayPayments (DP_ID, DP_RecordKind, DP_OpID, DP_Date, DP_AccNo, DP_PartNo, DP_Credit,
                             DP_Debit, DP_Saldo, DP_Flag, DP_INID, DP_BIN, DP_CLEARDATE, dp_incid, dp_unitid,
                             DP_PayWay, DP_Anul, DP_PayType, DP_OperatorUnitID)
    values (:DP_ID, 0, :DP_OpID, :DP_Date, :DP_AccNo, :DP_PartNo, :DP_Credit,
                             :dp_debit, :dp_saldo, :DP_Flag, :DP_INID, :DP_BIN, :DP_CLEARDATE, :dp_incid, :dp_unitid,
                             :DP_PayWay, :DP_Anul, :DP_PayType, :DP_OperatorUnitID);
  end
  else
    update DayPayments
      set DP_CREDIT = DP_CREDIT + :DP_CREDIT,
          DP_SALDO = DP_SALDO + :dp_saldo,
          DP_DEBIT = DP_DEBIT + :DP_DEBIT
      where
        DP_OPID = :DP_OPID and DP_Date = :DP_Date and
        DP_AccNo = :DP_AccNo and DP_PartNo = :DP_PartNo and
        DP_FLAG = :DP_FLAG and DP_INID = :DP_INID
        and DP_RecordKind = 0;
  exit;
end
/*SQLStop>1483*/

/*SQLStart>1484*/
ALTER TRIGGER INDETAIL_BI
AS
declare variable OpID integer;
declare variable OpUnitID integer;
declare variable PayDate date;
declare variable PayType char(1);
declare variable PayWay char(1);
declare variable Anul char(1);
declare variable DDS numeric(15,3);
declare variable DDSSum numeric(15, 3);
declare variable cnt integer;
BEGIN
    NEW.ID_NoFactorSum  = NEW.ID_Sum;

    select IN_OperatorID, IN_PayDate, IN_PayType, IN_PayDDS, IN_PayDDSSum, IN_OperatorUnitID, IN_PayWay, IN_Anul
    from Invoices 
    where IN_ID = NEW.ID_ID
    into :OpID, :PayDate, :PayType, :DDS, :DDSSum, :OpUnitID, :PayWay, :Anul;

    select count(*) from daypayments 
    where (dp_inid = NEW.ID_ID) and (DP_FLAG = "D")
    into :cnt;

    execute procedure DayPaymentsAdd(:OpID, :PayDate, NEW.ID_AccNo, NEW.ID_PartNo,
            New.ID_SUM, :PayType, NEW.ID_ID, NEW.ID_BIN, NEW.ID_UNITID, :PayWay, :Anul, :PayType, :OpUnitID);

    /* otrazqwa w daypayments DDSto */
    if ((New.ID_DDS <> 0) and (New.ID_DDS is not null) and (cnt = 0) ) then
      execute procedure DayPaymentsAdd(:OpID, :PayDate, NEW.ID_AccNo_D, NEW.ID_PartNo_D,
                                       DDS, 'D', NEW.ID_ID, NEW.ID_BIN_D, NEW.ID_UNITID_D, :PayWay, :Anul, :PayType, :OpUnitID);

    /* otrazqwa w daypayments lihvite */
    if ((New.ID_Lihvi <> 0) and (New.ID_Lihvi is not null)) then
      execute procedure DayPaymentsAdd(:OpID, :PayDate, NEW.ID_AccNo_L, NEW.ID_PartNo_L,
                                        New.ID_Lihvi, 'L', NEW.ID_ID, NEW.ID_BIN_L, NEW.ID_UNITID_L, :PayWay, :Anul, :PayType, :OpUnitID);

    if ( New.ID_DDS <> 0) then
    begin
      New.ID_DDS = (New.ID_SUM / DDSSum) * DDS;
      New.ID_ALL = (NEW.ID_SUM + NEW.ID_LIHVI + NEW.ID_DDS);
    end
END
/*SQLStop>1484*/

/*SQLStart>1485*/
create unique index DayPayUnique on DayPayments (DP_INID, DP_OPID, DP_FLAG, DP_DATE, DP_ACCNO, DP_PARTNO, DP_RecordKind);
/*SQLStop>1485*/