/*ALIAS>l_data*/

/*SQLStart>1062*/
CREATE TABLE CHAR_KL (
    CHAR_ID INTEGER NOT NULL,
    CHAR_REG INTEGER NOT NULL,
    CHAR_TEXT VARCHAR(240) NOT NULL);
/*SQLStop*/

/*SQLStart>1063*/
ALTER TABLE CHAR_KL ADD CONSTRAINT PK_CHAR_KL PRIMARY KEY (CHAR_ID)
/*SQLStop*/

/*SQLStart>1064*/
CREATE INDEX CHAR_KL_REG_IDX ON CHAR_KL (CHAR_REG);
/*SQLStop*/

/*SQLStart>1065*/
CREATE TABLE CHAR_KL_HIST (
    ID             INTEGER NOT NULL,
    HISTORY_DATE   DATE NOT NULL,
    HISTORY_TYPE   INTEGER NOT NULL,
    HISTORY_GROUP  INTEGER DEFAULT 0 NOT NULL,
    USER_ID        INTEGER NOT NULL,
    CHAR_ID INTEGER NOT NULL,
    CHAR_REG INTEGER NOT NULL,
    CHAR_TEXT VARCHAR(240) NOT NULL);
/*SQLStop*/

/*SQLStart>1066*/
ALTER TABLE CHAR_KL_HIST ADD PRIMARY KEY (ID);
/*SQLStop*/

/*SQLStart>1067*/
CREATE INDEX CHAR_KL_HIST_REG_IDX ON CHAR_KL_HIST (CHAR_REG);
/*SQLStop*/

/*SQLStart>1068*/
CREATE INDEX CHAR_KL_HIST_HG ON CHAR_KL_HIST (HISTORY_GROUP);
/*SQLStop*/

/*SQLStart>1069*/
CREATE GENERATOR GEN_HIST_CHAR_KL_ID
/*SQLStop*/

/*SQLStart>1070*/
CREATE OR ALTER TRIGGER char_kl_hist_bi for char_kl_hist
ACTIVE BEFORE INSERT OR UPDATE POSITION 0
as
begin
  if (new.ID is null) then 
    new.id = gen_id(GEN_HIST_CHAR_KL_ID,1);
  if (new.HISTORY_DATE is null) then 
    new.HISTORY_DATE = current_timestamp; 
end
/*SQLStop*/

/*SQLStart>1071*/
GRANT ALL ON CHAR_KL TO PUBLIC
/*SQLStop*/

/*SQLStart>1072*/
GRANT ALL ON CHAR_KL_HIST TO PUBLIC
/*SQLStop*/

/*SQLStart>1073*/
CREATE TABLE CHAR_TBL (
    REGISTER_ID INTEGER NOT NULL,
	REGISTER_TYPE INTEGER NOT NULL,
    CHAR_ID INTEGER NOT NULL);
/*SQLStop*/

/*SQLStart>1074*/
ALTER TABLE CHAR_TBL ADD CONSTRAINT PK_CHAR_TBL PRIMARY KEY (REGISTER_ID,REGISTER_TYPE,CHAR_ID);
/*SQLStop*/

/*SQLStart>1075*/
GRANT ALL ON CHAR_TBL TO PUBLIC;
/*SQLStop*/

/*SQLStart>1076*/
ALTER TABLE OBJECTREGISTER
    ADD OR_CERTOPER VARCHAR(240),
    ADD OR_CERTOPERDATE DATE;
/*SQLStop*/

/*SQLStart>1077*/
ALTER TABLE OBJECTREGISTER_HIST
    ADD OR_CERTOPER VARCHAR(240),
    ADD OR_CERTOPERDATE DATE;
/*SQLStop*/

/*SQLStart>1078*/
delete from system_strings where SYS_ID = 0;
/*SQLStop*/

/*SQLStart>1079*/
insert into system_strings (SYS_ID,SYS_STR) values (0,'1.5.59.1');
/*SQLStop*/

