/*ALIAS>prop_db*/

/*SQLStart>2533*/
CREATE OR ALTER trigger original_uid for originals
active before insert position 0
as
begin
    if ((new.originals_originalid is null) or (new.originals_originalid = 0)) then
    begin
        new.originals_originalid = gen_id(org_id_gen, 1);
    end
end
/*SQLStop*/

/*SQLStart>2534*/
ALTER TABLE ASSETS
    ADD ASSET_INSERT DATE,
    ADD ASSET_UPDATE DATE
/*SQLStop*/

/*SQLStart>2535*/
CREATE OR ALTER trigger assets_bi0 for assets
active before insert position 0
AS
begin
    if ((new.asset_id is null) or (new.asset_id = 0)) then
    begin
        new.asset_id = gen_id(asset_id_gen, 1);
    end
    new.asset_insert = current_timestamp;
end
/*SQLStop*/

/*SQLStart>2536*/
CREATE OR ALTER trigger assets_bu0 for assets
active before update position 0
AS
begin
    new.asset_update = current_timestamp;
end
/*SQLStop*/

/*SQLStart>2537*/
create or alter procedure GETVERDIRNUM
returns (
    VERSIONNUMBER integer,
    VERSIONDIR integer)
as
declare variable NNUM integer;
declare variable DIRNUM integer;
begin
   nnum= gen_id(ver_num_gen, 1);

   if(nnum > 1000) then
   begin
      nnum= -nnum;
      dirnum= 1;
   end
   else
   begin
      nnum= 0;
      dirnum= 0;
   end

   VERSIONNUMBER=gen_id(ver_num_gen, nnum);
   VERSIONDIR=gen_id(ver_dirnum_gen, dirnum);
   suspend;
end
/*SQLStop*/

/*SQLStart>2538*/
GRANT EXECUTE ON PROCEDURE GETVERDIRNUM TO PUBLIC;
/*SQLStop*/

/*SQLStart>2539*/
CREATE OR ALTER trigger version_cnt_event for versions
active before insert position 0
as
   declare variable nnum integer;
   declare variable dirnum integer;
begin
  if ((new.versions_versionnumber is not null) and
      (new.versions_dirnum is not null)) then
    exit;
  select * from getverdirnum
  into :nnum, :dirnum;

  new.versions_versionnumber= :nnum;
  new.versions_dirnum= :dirnum;
end
/*SQLStop*/

/*SQLStart>2540*/
update system_strings set sys_str = '6.7.205.1' where sys_id = 1401;  /*BackOffice*/
/*SQLStop*/
