/*ALIAS>prop_db*/

/*SQLStart>2220*/
CREATE TABLE DEALKIND (
    DK_ID    INTEGER NOT NULL,
    DK_CODE  VARCHAR(10),
    DK_TEXT  VARCHAR(255)
)
/*SQLStop*/

/*SQLStart>2222*/
ALTER TABLE DEALKIND ADD CONSTRAINT PK_DEALKIND PRIMARY KEY (DK_ID);
/*SQLStop*/

/*ManyStart>2224*/
GRANT ALL ON DEALKIND TO PUBLIC;
GRANT ALL ON DEALKIND TO SYSCREAT WITH GRANT OPTION;
/*ManyStop>*/

/*ManyStart>2226*/
CREATE GENERATOR DK_ID_GEN;
SET GENERATOR DK_ID_GEN TO 1;
/*ManyStop>*/

/*SQLStart>2228*/
CREATE OR ALTER TRIGGER SET_DK_ID FOR DEALKIND
ACTIVE BEFORE INSERT POSITION 0
AS
begin
  if ((NEW.DK_ID is NULL) OR (NEW.DK_ID < 1)) then
  begin
    NEW.DK_ID = GEN_ID(DK_ID_GEN, 1);
  end
end;
/*SQLStop*/

/*SQLStart>2230*/
ALTER TABLE INDETAIL
ADD ID_DEALKINDCODE VARCHAR(10);
/*SQLStop*/


/*SQLStart>2232*/
ALTER TABLE INDETAIL
ADD ID_DEALKINDTEXT VARCHAR(255);
/*SQLStop*/

/*SQLStart>2234*/
ALTER TABLE TAXI
ADD TAX_DK_ID INTEGER;
/*SQLStop*/

/*SQLStart>2236*/
ALTER TABLE RENTTYPES
ADD RT_DK_ID INTEGER;
/*SQLStop*/

/*SQLStart>2238*/
CREATE OR ALTER PROCEDURE INDETAILADD (
    ID_ID INTEGER,
    ID_VID INTEGER,
    ID_SUM NUMERIC(15,2),
    ID_DDS NUMERIC(15,2),
    ID_DDSPERCENT NUMERIC(15,2),
    ID_LIHVI NUMERIC(15,2),
    ID_ALL NUMERIC(15,2),
    ID_TEXT VARCHAR(250),
    ID_ACCNO VARCHAR(8),
    ID_PARTNO VARCHAR(18),
    ID_BIN VARCHAR(10),
    ID_ACCNO_D VARCHAR(8),
    ID_PARTNO_D VARCHAR(18),
    ID_BIN_D VARCHAR(10),
    ID_ACCNO_L VARCHAR(8),
    ID_PARTNO_L VARCHAR(18),
    ID_BIN_L VARCHAR(10),
    ID_DTSTART DATE,
    ID_DTSTOP DATE,
    ID_VID2 INTEGER,
    ID_PAYTYPE CHAR(1),
    ID_SUBTYPE CHAR(1),
    ID_MEASURE VARCHAR(6),
    ID_SINGLEPRICE NUMERIC(15,3),
    ID_QUANTITY NUMERIC(15,3),
    ID_UNITID INTEGER,
    ID_UNITID_L INTEGER,
    ID_UNITID_D INTEGER,
    ID_FACTOR NUMERIC(15,2),
    ID_DEALKINDCODE VARCHAR(10),
    ID_DEALKINDTEXT VARCHAR(255))
AS
DECLARE VARIABLE ID_NO INTEGER;
begin
  /* wzima sledwasht nomer za element ot taq faktura */
  select max(ID_No) from InDetail
  where ID_ID = :ID_ID into :ID_No;
  if (ID_No is null) then
    ID_No = 1;
  else
    ID_No = ID_No + 1;

  insert into InDetail (ID_ID, ID_NO, ID_VID, ID_SUM, ID_DDS,
                        ID_DDSPercent, ID_LIHVI, ID_ALL, ID_TEXT, ID_ACCNO,
                        ID_PARTNO, ID_BIN, ID_ACCNO_D, ID_PARTNO_D, ID_BIN_D,
                        ID_ACCNO_L, ID_PARTNO_L, ID_BIN_L,
                        ID_DTSTART, ID_DTSTOP, ID_REAL,
                        ID_VID2, ID_PayType, ID_Anul, ID_SubType,
                        ID_Measure, ID_SINGLEPRICE, ID_QUANTITY,ID_UNITID,ID_UNITID_L,ID_UNITID_D,
                        ID_FACTOR, ID_DEALKINDCODE, ID_DEALKINDTEXT)
  values               (:ID_ID, :ID_NO, :ID_VID, :ID_SUM, :ID_DDS,
                        :ID_DDSPercent, :ID_LIHVI, :ID_ALL, :ID_TEXT, :ID_ACCNO,
                        :ID_PARTNO, :ID_BIN, :ID_ACCNO_D, :ID_PARTNO_D, :ID_BIN_D,
                        :ID_ACCNO_L, :ID_PARTNO_L, :ID_BIN_L,
                        :ID_DTSTART, :ID_DTSTOP, "F",
                        :ID_VID2, :ID_PayType, "A", :ID_SubType,
                        :ID_Measure, :ID_SINGLEPRICE, :ID_QUANTITY,:ID_UNITID,:ID_UNITID_L,:ID_UNITID_D,
                        :ID_FACTOR, :ID_DEALKINDCODE, :ID_DEALKINDTEXT);
  exit;
end;
/*SQLStop*/

/*SQLStart>2240*/
update system_strings set sys_str = '6.7.184.1' where sys_id = 1401;  /*BackOffice*/
/*SQLStop*/
