/*ALIAS>prop_db*/

/*SQLStart>1360*/     
alter table Daypayments add dp_unitid integer;
/*SQLStop*/ 

/*SQLStart>1361*/     
create index DPUnitIDIndex on Daypayments (dp_unitid);
/*SQLStop*/ 

/*SQLStart>1362*/     
alter table InDetail 
  add id_unitid integer,
  add id_unitid_d integer,
  add id_unitid_l integer;

/*SQLStop*/ 

/*SQLStart>1363*/     
create procedure FillDayPaymentUnitID 
as
declare variable in_id integer;
declare variable in_obunit integer;
begin
  update Daypayments set dp_unitid = 0;

  for select in_id, in_obunit from invoices
      where (in_obunit > 0) and (in_obunit is not null)
      into :in_id, :in_obunit
  do begin
    update daypayments set dp_unitid = :in_obunit where dp_inid = :in_id;
    update indetail set id_unitid = :in_obunit, id_unitid_l = :in_obunit, id_unitid_d = :in_obunit where id_id = :in_id;
  end
end;
/*SQLStop*/ 

/*SQLStart>1364*/     
execute procedure FillDayPaymentUnitID;
/*SQLStop*/

/*SQLStart>1365*/
ALTER TRIGGER INDETAIL_BI 
AS
BEGIN
  exit;
END
/*SQLStop*/

/*SQLStart>1366*/
ALTER PROCEDURE DAYPAYMENTSADD(
    DP_OPID INTEGER,
    DP_DATE DATE,
    DP_ACCNO VARCHAR(8),
    DP_PARTNO VARCHAR(18),
    DP_CREDIT NUMERIC(15,2),
    DP_FLAG CHAR(1),
    DP_INID INTEGER,
    DP_BIN VARCHAR(10),
    DP_UNITID INTEGER)
AS
declare variable cnt integer;
declare variable dp_debit numeric(15,2);
declare variable dp_saldo numeric(15,2);
declare variable dp_cleardate date;
declare variable dp_incid smallint;
begin
  select count(*) from DayPayments
  where DP_OPID = :DP_OPID and DP_Date = :DP_Date and
        DP_AccNo = :DP_AccNo and DP_PartNo = :DP_PartNo and
        DP_INID = :DP_INID  and DP_FLAG = :DP_FLAG
  into :cnt;

  dp_saldo = dp_credit;
  dp_cleardate = AStripTime(DP_DATE);

  if (dp_credit < 0) then
  begin
    dp_debit = dp_credit;
    dp_credit = 0;
  end
  else
    dp_debit = 0; 

  if ((cnt is null) or (cnt = 0)) then
  begin
    select P_IncID from Partitions where P_AccNo = :DP_AccNo and P_No = :DP_PartNo into :dp_incid;
    if (dp_incid is null) then dp_incid = 0;
    insert into DayPayments (DP_OpID, DP_Date, DP_AccNo, DP_PartNo, DP_Credit,
                             DP_Debit, DP_Saldo, DP_Flag, DP_INID, DP_BIN, DP_CLEARDATE, dp_incid, dp_unitid)
    values (:DP_OpID, :DP_Date, :DP_AccNo, :DP_PartNo, :DP_Credit,
                             :dp_debit, :dp_saldo, :DP_Flag, :DP_INID, :DP_BIN, :DP_CLEARDATE, :dp_incid, :dp_unitid);
  end
  else
    update DayPayments
      set DP_CREDIT = DP_CREDIT + :DP_CREDIT,
          DP_SALDO = DP_SALDO + :dp_saldo,
          DP_DEBIT = DP_DEBIT + :DP_DEBIT
      where
        DP_OPID = :DP_OPID and DP_Date = :DP_Date and
        DP_AccNo = :DP_AccNo and DP_PartNo = :DP_PartNo and
        DP_FLAG = :DP_FLAG and DP_INID = :DP_INID;
  exit;
end
/*SQLStop*/

/*SQLStart>1367*/
ALTER TRIGGER INDETAIL_BI
AS
declare variable OpID integer;
declare variable PayDate date;
declare variable PayType char(1);
declare variable DDS numeric(15,3);
declare variable DDSSum numeric(15, 3);
declare variable cnt integer;
BEGIN
    NEW.ID_NoFactorSum  = NEW.ID_Sum;

    select IN_OperatorID, IN_PayDate, IN_PayType, IN_PayDDS, IN_PayDDSSum from Invoices 
    where IN_ID = NEW.ID_ID
    into :OpID, :PayDate, :PayType, :DDS, :DDSSum;

    select count(*) from daypayments 
    where (dp_inid = NEW.ID_ID) and (DP_FLAG = "D")
    into :cnt;

    execute procedure DayPaymentsAdd(:OpID, :PayDate, NEW.ID_AccNo, NEW.ID_PartNo,
            New.ID_SUM, :PayType, NEW.ID_ID, NEW.ID_BIN, NEW.ID_UNITID);

    /* otrazqwa w daypayments DDSto */
    if ((New.ID_DDS <> 0) and (New.ID_DDS is not null) and (cnt = 0) ) then
      execute procedure DayPaymentsAdd(:OpID, :PayDate, NEW.ID_AccNo_D, NEW.ID_PartNo_D,
                                       DDS, 'D', NEW.ID_ID, NEW.ID_BIN_D, NEW.ID_UNITID_D);

    /* otrazqwa w daypayments lihvite */
    if ((New.ID_Lihvi <> 0) and (New.ID_Lihvi is not null)) then
      execute procedure DayPaymentsAdd(:OpID, :PayDate, NEW.ID_AccNo_L, NEW.ID_PartNo_L,
                                        New.ID_Lihvi, 'L', NEW.ID_ID, NEW.ID_BIN_L, NEW.ID_UNITID_L);

    if ( New.ID_DDS <> 0) then
    begin
      New.ID_DDS = (New.ID_SUM / DDSSum) * DDS;
      New.ID_ALL = (NEW.ID_SUM + NEW.ID_LIHVI + NEW.ID_DDS);
    end
END
/*SQLStop*/

/*SQLStart>1368*/
ALTER PROCEDURE INDETAILADD(
    ID_ID INTEGER,
    ID_VID INTEGER,
    ID_SUM NUMERIC(15,2),
    ID_DDS NUMERIC(15,2),
    ID_DDSPERCENT NUMERIC(15,2),
    ID_LIHVI NUMERIC(15,2),
    ID_ALL NUMERIC(15,2),
    ID_TEXT VARCHAR(250),
    ID_ACCNO VARCHAR(8),
    ID_PARTNO VARCHAR(18),
    ID_BIN VARCHAR(10),
    ID_ACCNO_D VARCHAR(8),
    ID_PARTNO_D VARCHAR(18),
    ID_BIN_D VARCHAR(10),
    ID_ACCNO_L VARCHAR(8),
    ID_PARTNO_L VARCHAR(18),
    ID_BIN_L VARCHAR(10),
    ID_DTSTART DATE,
    ID_DTSTOP DATE,
    ID_VID2 INTEGER,
    ID_PAYTYPE CHAR(1),
    ID_SUBTYPE CHAR(1),
    ID_MEASURE VARCHAR(6),
    ID_SINGLEPRICE NUMERIC(15,3),
    ID_QUANTITY NUMERIC(15,3),
    ID_UNITID INTEGER,
    ID_UNITID_L INTEGER,
    ID_UNITID_D INTEGER
)
AS
declare variable ID_No integer;
begin
  /* wzima sledwasht nomer za element ot taq faktura */
  select max(ID_No) from InDetail
  where ID_ID = :ID_ID into :ID_No;
  if (ID_No is null) then
    ID_No = 1;
  else
    ID_No = ID_No + 1;

  insert into InDetail (ID_ID, ID_NO, ID_VID, ID_SUM, ID_DDS,
                        ID_DDSPercent, ID_LIHVI, ID_ALL, ID_TEXT, ID_ACCNO,
                        ID_PARTNO, ID_BIN, ID_ACCNO_D, ID_PARTNO_D, ID_BIN_D,
                        ID_ACCNO_L, ID_PARTNO_L, ID_BIN_L,
                        ID_DTSTART, ID_DTSTOP, ID_REAL,
                        ID_VID2, ID_PayType, ID_Anul, ID_SubType,
                        ID_Measure, ID_SINGLEPRICE, ID_QUANTITY,ID_UNITID,ID_UNITID_L,ID_UNITID_D)
  values               (:ID_ID, :ID_NO, :ID_VID, :ID_SUM, :ID_DDS,
                        :ID_DDSPercent, :ID_LIHVI, :ID_ALL, :ID_TEXT, :ID_ACCNO,
                        :ID_PARTNO, :ID_BIN, :ID_ACCNO_D, :ID_PARTNO_D, :ID_BIN_D,
                        :ID_ACCNO_L, :ID_PARTNO_L, :ID_BIN_L,
                        :ID_DTSTART, :ID_DTSTOP, "F",
                        :ID_VID2, :ID_PayType, "A", :ID_SubType,
                        :ID_Measure, :ID_SINGLEPRICE, :ID_QUANTITY,:ID_UNITID,:ID_UNITID_L,:ID_UNITID_D);
  exit;
end
/*SQLStop>*/

/*SQLStart>1369*/
ALTER table TAXI 
  add TAX_OBUNIT_L integer,
  add TAX_OBUNIT_D integer;
/*SQLStop*/

/*SQLStart>1370*/
update taxi set
  TAX_OBUNIT_L = TAX_OBUNIT,
  TAX_OBUNIT_D = TAX_OBUNIT;
/*SQLStop*/

/*SQLStart>1371*/
update taxi set
  TAX_OBUNIT_L = TAX_OBUNIT,
  TAX_OBUNIT_D = TAX_OBUNIT;
/*SQLStop*/

/*SQLStart>1372*/
alter table renttypes
  add RT_UNITID integer,
  add RT_UNITID_L integer,
  add RT_UNITID_D integer;
/*SQLStop*/

/*SQLStart>1373*/
update renttypes set
   RT_UNITID = 0,
   RT_UNITID_L = 0,
   RT_UNITID_D = 0;
/*SQLStop*/

/*SQLStart>1374*/
alter table NUMKINDDOC_NOM
  add NUMKIND_NAME VARCHAR(30);
/*SQLStop*/

/*SQLStart>1375*/
update NUMKINDDOC_NOM
  set NUMKIND_NAME = NUMKIND_PREFIX;
/*SQLStop*/

/*SQLStart>1376*/
alter table taxi
  add tax_putyearintext smallint default 0;
/*SQLStop*/

/*SQLStart>1377*/
update taxi
  set tax_putyearintext = 0;
/*SQLStop*/